package com.handheld.Barcode1DDemo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.SimpleAdapter;
import android.widget.TextView;
import android.widget.Toast;
import cn.pda.serialport.SerialPort;

import com.handheld.Barcode1D.Barcode1DManager;
import com.handheld.apiinstructions.R;
import com.handheld.apiinstructions.SettingActivity;
import com.handheld.apiinstructions.Util;

public class Barcode1DActivity extends Activity {
	/** UI **/
	private EditText eidtBarCount;
	private Button buttonClear;
	private ListView listViewData;
	private CheckBox checkBoxPer;
	private Button buttonScan;
	private Button buttonExit;
	private TextView textView_title_config;
	private List<Barcode> listBarcode = new ArrayList<Barcode>();
	private List<Map<String, String>> listMap;
	private SimpleAdapter adapter = null;
	private Timer scanTimer = null;
	private int fileCount ;
	private String what = "barcode";
//	private int barcodeCount = 0;
	BroadcastReceiver receive;
private Barcode1DManager manager;
	private Handler mHandler = new Handler() {
		public void handleMessage(android.os.Message msg) {
			if (msg.what == Barcode1DManager.Barcode1D) {
				String data = msg.getData().getString("data");
				sortAndadd(listBarcode, data);
				addListView();
				eidtBarCount.setText(listBarcode.size() + "");
//				barcodeCount++;
				Util.play(1, 0);
			}
		};
	};

	private void addListView() {
		listMap = new ArrayList<Map<String, String>>();
		int id = 1;
		for (Barcode barcode : listBarcode) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("id", id + "");
			map.put("barcode", barcode.getBarcode());
			map.put("count", barcode.getCount() + "");
			listMap.add(map);
		}
		adapter = new SimpleAdapter(this, listMap, R.layout.listview_item,
				new String[] { "id", "barcode", "count", }, new int[] {
						R.id.textView_list_item_id,
						R.id.textView_list_item_barcode,
						R.id.textView_list_item_count });
		listViewData.setAdapter(adapter);
	}
	private int port = 0;
	private int power = SerialPort.Power_Scaner;
	private int baudrate = 9600;
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		// set HOME key scan
		getWindow().addFlags(0x80000000);
		super.onCreate(savedInstanceState);
		setTitle(R.string._1d_2d_demo);
		setContentView(R.layout.activity_1d2d);
		manager = new Barcode1DManager();
		manager.Open(mHandler);
		receive  = new FunkeyListener();
		//Registered radio receivers
		IntentFilter filter = new IntentFilter();
		filter.addAction("android.intent.action.FUN_KEY");
		registerReceiver(receive, filter);
		initView();
		//init sound class 
		Util.initSoundPool(this);
	}
	@Override
	protected void onResume() {
		// TODO Auto-generated method stub
		super.onResume();
//		SharedPreferences preference = getSharedPreferences("serialport", Context.MODE_PRIVATE);
//		port = preference.getInt(what+"port", SerialPort.com0);
//		baudrate = preference.getInt(what+"baudrate", SerialPort.baudrate9600);
//		power = preference.getInt(what+"power", SerialPort.Power_Scaner);
//		Log.e(what+"baudrate", baudrate+"");
//		Barcode1DManager.BaudRate = baudrate;
//		Barcode1DManager.Port = port;
//		Barcode1DManager.Power = power;
		String powerString = "";
		switch (power) {
		case SerialPort.Power_3v3:
			powerString = "power_3V3";
			break;
		case SerialPort.Power_5v:
			powerString = "power_5V";
			break;
		case SerialPort.Power_Scaner:
			powerString = "scan_power";
			break;
		case SerialPort.Power_Psam:
			powerString = "psam_power";
			break;
		case SerialPort.Power_Rfid:
			powerString = "rfid_power";
			break;
		default:
			break;
		}
		textView_title_config = (TextView) findViewById(R.id.textview_title_config);
		textView_title_config.setText("Port:com"+port+";Baudrate:"+baudrate+";Power:"+powerString);
//		manager.SetCodedFormat("GBK");// Set the format, the default utf-8
		
	}
	@Override
	protected void onPause() {
		// TODO Auto-generated method stub
		super.onPause();
	}
	private List<Barcode> sortAndadd(List<Barcode> list, String barcode) {
		Barcode goods = new Barcode();
		goods.setBarcode(barcode);
		int temp = 1;
		if (list == null || list.size() == 0) { 
			goods.setCount(temp);
			list.add(goods);
			return list;
		}
		
		for (int i = 0; i < list.size(); i++) { 
			if (barcode.equals(list.get(i).getBarcode())) {
				temp = list.get(i).getCount() + temp;
				goods.setCount(temp);
				for (int j = i; j > 0; j--) {
					list.set(j, list.get(j - 1)); 
				}
				list.set(0, goods);
				return list;
			}
		}
		// 
		Barcode lastgoods = list.get(list.size() - 1); 
		for (int j = list.size() - 1; j >= 0; j--) {
			if (j == 0) {
				goods.setCount(temp);
				list.set(j, goods); 
			} else {
				list.set(j, list.get(j - 1));
			}

		}
		list.add(lastgoods);
		return list;
	}

	long exitSytemTime = 0;

	@Override
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		Log.e("", "keycode == " + keyCode);
//		if (keyCode == KeyEvent.KEYCODE_HOME) {
//			Barcode1D2DManager.Scan();
//		}
		if(keyCode == 131 || keyCode == 132 || keyCode == 133 || keyCode == 134|| keyCode == 135){
			manager.Scan();
		}

		if (keyCode == KeyEvent.KEYCODE_BACK) {
			if (System.currentTimeMillis() - exitSytemTime > 2000) {
				Toast.makeText(getApplicationContext(), R.string.exitSystem,
						Toast.LENGTH_SHORT).show();
				exitSytemTime = System.currentTimeMillis();
				return true;
			} else {
				finish();
			}
		}
		return super.onKeyDown(keyCode, event);
	}

	@Override
	protected void onDestroy() {
		// Unregister receiver
		unregisterReceiver(receive);
		fileCount++;
		SharedPreferences shared = this.getPreferences(Context.MODE_PRIVATE);
		SharedPreferences.Editor editor = shared.edit();
		editor.putInt("fileCount", fileCount);
		editor.commit();
		if(scanTimer!= null){
			scanTimer.cancel();
		}
			manager.Close();
		super.onDestroy();
	}

	private void initView() {
		eidtBarCount = (EditText) findViewById(R.id.editText_barcode_count);
		buttonClear = (Button) findViewById(R.id.button_clear);
		listViewData = (ListView) findViewById(R.id.listView_data_list);
		checkBoxPer = (CheckBox) findViewById(R.id.checkbox_per_100ms);
		buttonScan = (Button) findViewById(R.id.button_scan);
		buttonExit = (Button) findViewById(R.id.button_exit);
		textView_title_config = (TextView) findViewById(R.id.textview_title_config);
		buttonScan.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				manager.Scan();

			}
		});
		checkBoxPer.setOnCheckedChangeListener(new OnCheckedChangeListener() {
			
			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				if(isChecked){
					buttonScan.setClickable(false);
					buttonScan.setTextColor(Color.GRAY);
					scanTimer = new Timer();
					scanTimer.schedule(new TimerTask() {
						
						@Override
						public void run() {
								manager.Scan();
						}
					}, 100, 200);
				}else{
					buttonScan.setClickable(true);
					buttonScan.setTextColor(Color.BLACK);
					if(scanTimer != null){
						scanTimer.cancel();
					}
				}
				
			}
		});
		
		buttonClear.setOnClickListener(new OnClickListener() {
			
			@Override
			public void onClick(View v) {
				eidtBarCount.setText("");
				listBarcode.removeAll(listBarcode);
				listViewData.setAdapter(null);
			}
		});
		
		buttonExit.setOnClickListener(new OnClickListener() {
			
			@Override
			public void onClick(View v) {
				
				finish();
			}
		});

	}
	
	private class FunkeyListener extends BroadcastReceiver{

		@Override
		public void onReceive(Context context, Intent intent) {
			boolean defaultdown=false;
	        int keycode = intent.getIntExtra("keycode", 0);    
	        boolean keydown = intent.getBooleanExtra("keydown", defaultdown);      
	        if(keydown){
	        	if(keycode == 131 || keycode == 132 || keycode == 133 || keycode == 134|| keycode == 135){
					manager.Scan();
				}
	        }
		}
	}
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		getMenuInflater().inflate(R.menu.main, menu);
		return super.onCreateOptionsMenu(menu);
	}
	//go to settingActivity
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		if(item.getItemId() == R.id.action_settings){
			Intent intent = new Intent(Barcode1DActivity.this, SettingActivity.class);
			intent.putExtra("what", what);
			startActivity(intent);
		}
		return super.onOptionsItemSelected(item);
	}

}
